# Funmate API Documentation

## Base URL
```
https://funmate.snaplimit.com/user/
```

## Authentication
All authenticated endpoints require:
- **Device-ID** header (required)
- **Session-Token** header (required for authenticated endpoints)
- **Encrypted request payload** (all requests must be encrypted)

## Common Response Format
```json
{
  "status": 200,
  "message": "Success message",
  "data": {
    // Response data
  },
  "new_session_token": "new_session_token_here" // Optional, for authenticated endpoints
}
```

## Error Codes
- **400** - Bad Request (Invalid input, missing fields, etc.)
- **401** - Unauthorized (Invalid session token)
- **405** - Method Not Allowed
- **429** - Too Many Requests (Rate limited)
- **500** - Internal Server Error

---

## 📱 Authentication & Account Management

### 1. User Login/Signup
**Endpoint:** `POST /account`

**Headers:**
```
Device-ID: your_device_id_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "email": "user@example.com",
  "device_id": "your_device_id_here",
  "refercode": "optional_referral_code" // Optional
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/account" \
  -H "Device-ID: abc123def456" \
  -H "Content-Type: application/json" \
  -d '{"email": "user@example.com", "device_id": "abc123def456", "refercode": "FRIEND01"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Login successful",
  "data": {
    "user_id": 1,
    "email": "user@example.com",
    "refercode": "user1234",
    "coins": 100,
    "can_claim": true
  },
  "session_token": "strong_session_token_64_chars"
}
```

### 2. User Logout
**Endpoint:** `POST /logout`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/logout" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1}'
```

### 3. Delete Account
**Endpoint:** `POST /delete_account`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/delete_account" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1}'
```

---

## 🏠 Home & App Settings

### 4. Get App Settings (Public)
**Endpoint:** `POST /home`

**Headers:**
```
Device-ID: your_device_id_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "action": "public"
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/home" \
  -H "Device-ID: abc123def456" \
  -H "Content-Type: application/json" \
  -d '{"action": "public"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "App settings fetched",
  "data": {
    "maintenance": 0,
    "vpn_allowed": 1,
    "guest_mode": 1,
    "earning_mode": 1,
    "gamezop_timer": 30,
    "ad_index": 1,
    "gamezop_card_status": 1,
    "ad_app_size": "medium",
    "ad_controls": [
      {
        "screen_name": "vehicle_guess",
        "interstitial_ad": 1,
        "banner_ad": 0,
        "native_ad": 1,
        "reward_ad": 1,
        "appopen_ad": 0
      }
    ],
    "links": {
      "how_to": "https://example.com/how-to",
      "telegram": "https://t.me/rewardapp",
      "support": "https://example.com/support"
    }
  }
}
```

### 5. Get Home Data (Authenticated)
**Endpoint:** `POST /home`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "action": "auth",
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/home" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"action": "auth", "user_id": 1}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Home data fetched",
  "data": {
    "maintenance": 0,
    "vpn_allowed": 1,
    "guest_mode": 1,
    "earning_mode": 1,
    "gamezop_timer": 30,
    "ad_index": 1,
    "gamezop_card_status": 1,
    "ad_app_size": "medium",
    "ad_controls": [...],
    "user_coins": 150,
    "daily_checkin": {
      "can_claim": true
    },
    "links": {
      "how_to": "https://example.com/how-to",
      "telegram": "https://t.me/rewardapp",
      "support": "https://example.com/support"
    }
  },
  "new_session_token": "new_session_token_here"
}
```

---

## 🎯 Task Management

### 6. Get Task Questions
**Endpoint:** `POST /task_questions`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "task_type": "math_fact", // math_fact, alphabet_guess, colour_guess, vehicle_guess
  "limit": 10 // Optional, default 10, max 50
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/task_questions" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "task_type": "math_fact", "limit": 5}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Questions fetched",
  "data": {
    "questions": [
      {
        "id": 1,
        "task_type": "math_fact",
        "question": "What is 5 + 3?",
        "options": ["6", "7", "8", "9"],
        "correct_answer": "8"
      }
    ],
    "reward_coins": "10-20"
  }
}
```

### 7. Complete Task (Check Limits Only)
**Endpoint:** `POST /complete_task`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "earned_coins": 15,
  "by_task": "math_fact",
  "created_at": "2025-01-15 10:30:00" // Optional
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/complete_task" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "earned_coins": 15, "by_task": "math_fact"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Task completed",
  "data": {
    "show_ad": true,
    "total_coins": 165,
    "claim_timer": 5,
    "task_limits": {
      "enabled": true,
      "remaining_limit": 4,
      "daily_limit": 5
    },
    "referral_reward": {
      "awarded": false
    }
  },
  "new_session_token": "new_session_token_here"
}
```

### 8. Final Submit (Complete Task with Coin Update)
**Endpoint:** `POST /final_submit`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "earned_coins": 15,
  "by_task": "math_fact",
  "created_at": "2025-01-15 10:30:00" // Optional
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/final_submit" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "earned_coins": 15, "by_task": "math_fact"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Final submission completed successfully",
  "data": {
    "total_coins": 180,
    "earned_coins": 15,
    "limits": [
      [
        ["daily_limit", 5],
        ["remaining_limit", 3],
        ["task_type", "math_fact"],
        ["used_count", 2]
      ]
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

### 9. Complete Website Task
**Endpoint:** `POST /complete_website_task`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "visit_duration": 45, // Seconds spent on website
  "earned_coins": 25,
  "created_at": "2025-01-15 10:30:00" // Optional
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/complete_website_task" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "visit_duration": 45, "earned_coins": 25}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Website task completed successfully",
  "data": {
    "total_coins": 205,
    "show_ad": false,
    "earned_coins": 25,
    "task_limits": {
      "enabled": false,
      "remaining_limit": null,
      "daily_limit": null
    },
    "referral_reward": {
      "awarded": false
    },
    "website_task": {
      "id": 1,
      "url": "https://example.com",
      "timer": 30,
      "visit_duration": 45
    }
  },
  "new_session_token": "new_session_token_here"
}
```

---

## 🎁 Daily Check-in

### 10. Check Daily Check-in Status
**Endpoint:** `POST /checkin_status`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/checkin_status" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Checkin status fetched",
  "data": {
    "can_claim": true,
    "coins_reward": 50,
    "last_claimed": "2025-01-14 10:30:00",
    "next_available": "2025-01-16 00:00:00",
    "streak_days": 3
  },
  "new_session_token": "new_session_token_here"
}
```

### 11. Claim Daily Check-in
**Endpoint:** `POST /daily_checkin`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "earned_coins": 50 // Optional, uses app settings if not provided
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/daily_checkin" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "earned_coins": 50}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Daily checkin claimed successfully",
  "data": {
    "coins_earned": 50,
    "total_coins": 230,
    "next_checkin_available": "2025-01-16 00:00:00"
  },
  "new_session_token": "new_session_token_here"
}
```

---

## 🎫 Promo Codes & Referrals

### 12. Apply Promo Code
**Endpoint:** `POST /promocode`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "code": "WELCOME50"
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/promocode" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "code": "WELCOME50"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Promo code applied",
  "data": {
    "coins_awarded": 50,
    "coins": 280
  },
  "new_session_token": "new_session_token_here"
}
```

### 13. Apply Referral Code
**Endpoint:** `POST /apply_refercode`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "refercode": "FRIEND01"
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/apply_refercode" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "refercode": "FRIEND01"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Referral code applied successfully",
  "data": {
    "message": "Referral code applied successfully! You will receive your referral reward after your first successful redeem."
  },
  "new_session_token": "new_session_token_here"
}
```

---

## 💰 Redeem System

### 14. List Redeem Categories
**Endpoint:** `POST /redeem`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "action": "list_categories"
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/redeem" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "action": "list_categories"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Categories fetched",
  "data": {
    "categories": [
      {
        "category_id": 1,
        "category_name": "Gift Card & Payments",
        "category_image_url": "https://example.com/giftcard.png"
      },
      {
        "category_id": 2,
        "category_name": "UPI Transfer",
        "category_image_url": "https://example.com/upi.png"
      }
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

### 15. List Subcategories
**Endpoint:** `POST /redeem`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "action": "list_subcategories",
  "category_id": 1,
  "sub_category_name": "Google Play" // Optional filter
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/redeem" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "action": "list_subcategories", "category_id": 1}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Subcategories fetched",
  "data": {
    "subcategories": [
      {
        "id": 1,
        "sub_category_name": "Google Play ₹100",
        "sub_category_image_url": "https://example.com/googleplay100.png",
        "coins": 1000,
        "cash": 100,
        "is_enabled": 1
      }
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

### 16. Redeem Item
**Endpoint:** `POST /redeem`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "action": "redeem",
  "subcategory_id": 1
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/redeem" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "action": "redeem", "subcategory_id": 1}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Redeem request successful",
  "data": {
    "coins": 180, // Remaining coins after deduction
    "gift_code": "ABC123DEF456",
    "created_at": "15/01/2025 10:30 AM"
  },
  "new_session_token": "new_session_token_here"
}
```

### 17. Get Redeem History
**Endpoint:** `POST /redeem_history`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/redeem_history" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Redeem history fetched",
  "data": {
    "history": [
      {
        "id": 1,
        "redeem_option_name": "Gift Card & Payments - Google Play ₹100",
        "image_url": "https://example.com/googleplay100.png",
        "gift_code": "ABC123DEF456",
        "pin": "1234", // For Flipkart vouchers
        "status": "approved", // approved, pending, rejected
        "rejection_reason": null,
        "cash": 100,
        "created_at": "15/01/2025 10:30 AM"
      }
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

---

## 🎮 Game Integration

### 18. Gamezop API
**Endpoint:** `GET /gamezop_api`

**Query Parameters:**
- `action`: search, category, tag, all, list-categories, list-tags, game-details
- `query`: Search term (for search action)
- `name`: Category name (for category action)
- `tag`: Tag name (for tag action)
- `code`: Game code (for game-details action)

**cURL Examples:**

**Get all games:**
```bash
curl "https://funmate.snaplimit.com/user/gamezop_api?action=all"
```

**Search games:**
```bash
curl "https://funmate.snaplimit.com/user/gamezop_api?action=search&query=puzzle"
```

**Get games by category:**
```bash
curl "https://funmate.snaplimit.com/user/gamezop_api?action=category&name=Puzzle%20%26%20Logic"
```

**Get game details:**
```bash
curl "https://funmate.snaplimit.com/user/gamezop_api?action=game-details&code=SJX7TGkDq1X"
```

---

## 🛠️ Utility & Status

### 19. Check User Status
**Endpoint:** `POST /utility`

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "action": "check_status"
}
```

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/utility" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "action": "check_status"}'
```

**Response:**
```json
{
  "status": 200,
  "message": "Status fetched",
  "data": {
    "update": {
      "app_link": "https://example.com/app.apk",
      "version": "1.0.1",
      "version_code": 2,
      "changelogs": "Bug fixes"
    },
    "maintenance": 0,
    "vpn_allowed": 1,
    "is_blocked": 0,
    "links": {
      "how_to": "https://example.com/how-to",
      "telegram": "https://t.me/rewardapp",
      "support": "https://example.com/support"
    }
  },
  "new_session_token": "new_session_token_here"
}
```

---

## 📊 Task Types

The following task types are available:

| Task Type | Description | Reward Range |
|-----------|-------------|--------------|
| `math_fact` | Mathematics fact questions | 10-20 coins |
| `alphabet_guess` | Alphabet recognition games | 10-15 coins |
| `colour_guess` | Color identification puzzles | 5-10 coins |
| `vehicle_guess` | Vehicle recognition games | 12-25 coins |

---

## 🔐 Security Features

1. **Request Encryption**: All requests must be encrypted using the app's encryption mechanism
2. **Session Management**: Session tokens are required for authenticated endpoints
3. **Rate Limiting**: API calls are rate-limited per user
4. **Device Binding**: One device per account policy
5. **Input Validation**: All inputs are validated and sanitized

---

## 📝 Notes

1. **Session Tokens**: Session tokens are refreshed on each authenticated request
2. **Task Limits**: Daily task limits are enforced based on app settings
3. **Referral Rewards**: Referral rewards are awarded on first successful redeem
4. **Website Tasks**: Website tasks are unlimited but require minimum visit duration
5. **Maintenance Mode**: App can be put in maintenance mode via admin panel
6. **VPN Detection**: VPN usage can be detected and blocked based on settings

---

## 🚀 Getting Started

1. **Register/Login**: Use the `/account` endpoint to create or login to your account
2. **Get App Settings**: Use `/home` with `action: public` to get app configuration
3. **Authenticate**: Use `/home` with `action: auth` to get user-specific data
4. **Play Games**: Use `/task_questions` to get questions and `/final_submit` to complete tasks
5. **Daily Check-in**: Use `/daily_checkin` to claim daily rewards
6. **Redeem**: Use `/redeem` endpoints to exchange coins for gift cards

---

*This documentation covers all available endpoints in the Funmate API. For any questions or support, please contact the development team.*
