# Funmate Tasks API Documentation

## Base URL
```
https://funmate.snaplimit.com/user/
```

## Authentication
All task endpoints require:
- **Device-ID** header (required)
- **Session-Token** header (required)
- **Encrypted request payload** (all requests must be encrypted)

---

## 🎯 Task Types Available

| Task Type | Description | Reward Range | Daily Limit |
|-----------|-------------|--------------|-------------|
| `math_fact` | Mathematics fact questions | 10-20 coins | 5-8 attempts |
| `alphabet_guess` | Alphabet recognition games | 10-15 coins | 5-8 attempts |
| `colour_guess` | Color identification puzzles | 5-10 coins | 10-15 attempts |
| `vehicle_guess` | Vehicle recognition games | 12-25 coins | 15-20 attempts |

---

## 📋 Task-Related Endpoints

### 1. Get Task Questions
**Endpoint:** `POST /task_questions`

**Description:** Fetches a specified number of questions for a specific task type.

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "task_type": "math_fact",
  "limit": 10
}
```

**Parameters:**
- `user_id` (required): User ID
- `task_type` (required): One of: `math_fact`, `alphabet_guess`, `colour_guess`, `vehicle_guess`
- `limit` (optional): Number of questions to fetch (default: 10, max: 50)

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/task_questions" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": 1,
    "task_type": "math_fact",
    "limit": 5
  }'
```

**Response:**
```json
{
  "status": 200,
  "message": "Questions fetched",
  "data": {
    "questions": [
      {
        "id": 1,
        "task_type": "math_fact",
        "question": "What is 5 + 3?",
        "options": ["6", "7", "8", "9"],
        "correct_answer": "8"
      },
      {
        "id": 2,
        "task_type": "math_fact",
        "question": "What is 12 - 4?",
        "options": ["6", "7", "8", "9"],
        "correct_answer": "8"
      }
    ],
    "reward_coins": "10-20"
  }
}
```

---

### 2. Get Task Limits
**Endpoint:** `POST /task_limits`

**Description:** Fetches daily limits and usage statistics for tasks.

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "task_type": "math_fact"
}
```

**Parameters:**
- `user_id` (required): User ID
- `task_type` (optional): Specific task type to check. If not provided, returns all task types

**cURL Example (Specific Task):**
```bash
curl -X POST "https://funmate.snaplimit.com/user/task_limits" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": 1,
    "task_type": "math_fact"
  }'
```

**cURL Example (All Tasks):**
```bash
curl -X POST "https://funmate.snaplimit.com/user/task_limits" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": 1
  }'
```

**Response (Specific Task):**
```json
{
  "status": 200,
  "message": "Task limits fetched",
  "data": {
    "enabled": true,
    "earning_mode": 1,
    "vpn_allowed": 1,
    "native_ad_load_refresh_count": 3,
    "coins": 150,
    "limits": [
      {
        "task_type": "math_fact",
        "daily_limit": 6,
        "used_count": 2,
        "remaining_limit": 4,
        "reward_coins": 15,
        "ad_index": 2,
        "important_ad_type": "native"
      }
    ],
    "ad_index": [2]
  },
  "new_session_token": "new_session_token_here"
}
```

**Response (All Tasks):**
```json
{
  "status": 200,
  "message": "Task limits fetched",
  "data": {
    "enabled": true,
    "earning_mode": 1,
    "vpn_allowed": 1,
    "native_ad_load_refresh_count": 3,
    "coins": 150,
    "limits": [
      {
        "task_type": "math_fact",
        "daily_limit": 6,
        "used_count": 2,
        "remaining_limit": 4,
        "reward_coins": 15,
        "ad_index": 2,
        "important_ad_type": "native"
      },
      {
        "task_type": "alphabet_guess",
        "daily_limit": 7,
        "used_count": 1,
        "remaining_limit": 6,
        "reward_coins": 12,
        "ad_index": 1,
        "important_ad_type": "inter"
      }
    ],
    "ad_index": [2, 1]
  },
  "new_session_token": "new_session_token_here"
}
```

---

### 3. Complete Task (Check Limits Only)
**Endpoint:** `POST /complete_task`

**Description:** Checks if user can complete a task and returns task limits without updating coins.

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "earned_coins": 15,
  "by_task": "math_fact",
  "created_at": "2025-01-15 10:30:00"
}
```

**Parameters:**
- `user_id` (required): User ID
- `earned_coins` (required): Coins earned from task completion
- `by_task` (required): Task type that was completed
- `created_at` (optional): Task completion timestamp

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/complete_task" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": 1,
    "earned_coins": 15,
    "by_task": "math_fact",
    "created_at": "2025-01-15 10:30:00"
  }'
```

**Response (Success - Can Complete):**
```json
{
  "status": 200,
  "message": "Task completed",
  "data": {
    "show_ad": true,
    "total_coins": 165,
    "claim_timer": 5,
    "task_limits": {
      "enabled": true,
      "remaining_limit": 3,
      "daily_limit": 6
    },
    "referral_reward": {
      "awarded": false
    }
  },
  "new_session_token": "new_session_token_here"
}
```

**Response (Website Task Available):**
```json
{
  "status": 200,
  "message": "Task completed",
  "data": {
    "show_ad": false,
    "total_coins": 165,
    "website_task": {
      "id": 1,
      "url": "https://example.com",
      "timer": 30
    },
    "task_limits": {
      "enabled": true,
      "remaining_limit": 3,
      "daily_limit": 6
    },
    "referral_reward": {
      "awarded": false
    }
  },
  "new_session_token": "new_session_token_here"
}
```

**Response (Daily Limit Reached):**
```json
{
  "status": 400,
  "message": "Daily limit reached for task type: math_fact. Limit: 6 per day.",
  "data": [],
  "new_session_token": "new_session_token_here"
}
```

---

### 4. Final Submit (Complete Task with Coin Update)
**Endpoint:** `POST /final_submit`

**Description:** Finalizes task completion, updates user coins, and records task completion.

**Headers:**
```
Device-ID: your_device_id_here
Session-Token: your_session_token_here
Content-Type: application/json
```

**Request Body:**
```json
{
  "user_id": 1,
  "earned_coins": 15,
  "by_task": "math_fact",
  "created_at": "2025-01-15 10:30:00"
}
```

**Parameters:**
- `user_id` (required): User ID
- `earned_coins` (required): Coins earned from task completion
- `by_task` (required): Task type that was completed
- `created_at` (optional): Task completion timestamp

**cURL Example:**
```bash
curl -X POST "https://funmate.snaplimit.com/user/final_submit" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{
    "user_id": 1,
    "earned_coins": 15,
    "by_task": "math_fact",
    "created_at": "2025-01-15 10:30:00"
  }'
```

**Response (Success):**
```json
{
  "status": 200,
  "message": "Final submission completed successfully",
  "data": {
    "total_coins": 180,
    "earned_coins": 15,
    "limits": [
      [
        ["daily_limit", 6],
        ["remaining_limit", 2],
        ["task_type", "math_fact"],
        ["used_count", 4]
      ]
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

**Response (Daily Limit Reached):**
```json
{
  "status": 400,
  "message": "Daily limit reached for task type: math_fact. Limit: 6 per day.",
  "data": [],
  "new_session_token": "new_session_token_here"
}
```

---

## 🔄 Task Workflow

### Complete Task Flow:

1. **Get Task Questions** → `/task_questions`
   - Fetch questions for a specific task type
   - Returns questions with options and correct answers

2. **Check Task Limits** → `/task_limits`
   - Check daily limits and remaining attempts
   - Verify if user can complete more tasks

3. **Complete Task** → `/complete_task`
   - Check if task can be completed
   - Returns ad display info and limits
   - Does NOT update coins yet

4. **Final Submit** → `/final_submit`
   - Finalizes task completion
   - Updates user coins
   - Records task completion in database
   - Updates daily usage counters

---

## 📊 Task Limits System

### Daily Limits:
- Each task type has a daily limit (e.g., 5-8 attempts per day)
- Limits are randomized per user per day
- Once limit is reached, user cannot complete more tasks of that type until next day

### Usage Tracking:
- `used_count`: Number of tasks completed today
- `remaining_limit`: Tasks remaining for today
- `daily_limit`: Total tasks allowed per day for this user
- `ad_index`: Ad frequency for this task type

### Task States:
- **Available**: User can complete tasks
- **Limit Reached**: User has reached daily limit
- **Disabled**: Task type is disabled by admin

---

## 🎮 Task Examples

### Math Fact Task:
```bash
# Get math questions
curl -X POST "https://funmate.snaplimit.com/user/task_questions" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "task_type": "math_fact", "limit": 3}'

# Complete math task
curl -X POST "https://funmate.snaplimit.com/user/complete_task" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "earned_coins": 15, "by_task": "math_fact"}'

# Final submit
curl -X POST "https://funmate.snaplimit.com/user/final_submit" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "earned_coins": 15, "by_task": "math_fact"}'
```

### Alphabet Guess Task:
```bash
# Get alphabet questions
curl -X POST "https://funmate.snaplimit.com/user/task_questions" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "task_type": "alphabet_guess", "limit": 5}'

# Check limits
curl -X POST "https://funmate.snaplimit.com/user/task_limits" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "task_type": "alphabet_guess"}'

# Complete alphabet task
curl -X POST "https://funmate.snaplimit.com/user/final_submit" \
  -H "Device-ID: abc123def456" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d '{"user_id": 1, "earned_coins": 12, "by_task": "alphabet_guess"}'
```

---

## 🚨 Error Handling

### Common Error Responses:

**Invalid Task Type:**
```json
{
  "status": 400,
  "message": "Invalid task_type"
}
```

**Daily Limit Reached:**
```json
{
  "status": 400,
  "message": "Daily limit reached for task type: math_fact. Limit: 6 per day."
}
```

**Invalid User ID:**
```json
{
  "status": 400,
  "message": "Invalid user_id"
}
```

**Unauthorized:**
```json
{
  "status": 401,
  "message": "Unauthorized"
}
```

**Too Many Requests:**
```json
{
  "status": 429,
  "message": "Too many requests"
}
```

---

## 🔐 Security Features

1. **Request Encryption**: All requests must be encrypted
2. **Session Authentication**: Valid session token required
3. **Rate Limiting**: Per-user request limits
4. **Input Validation**: All parameters validated
5. **SQL Injection Protection**: Prepared statements used
6. **Device Binding**: One device per account policy

---

## 📝 Notes

- **Randomized Rewards**: Coins earned are randomized within the specified range
- **Daily Reset**: Task limits reset at midnight (Asia/Kolkata timezone)
- **Ad Integration**: Ad display is controlled by task limits and app settings
- **Website Tasks**: May override regular tasks when available
- **Session Refresh**: Session tokens are refreshed on each request

---

*This documentation covers all task-related endpoints in the Funmate API. For complete API documentation, refer to the main FUNMATE_API_DOCUMENTATION.md file.*
